:- module(selectionFunctions,[selectionFunction/2]).

:- use_module(library(random)).
:- use_module(library(lists)).
:- use_module(helperFunctions).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% SELECTION FUNCTIONS, controlling which sentence is expanded next from a given player     %%%
%%% For the proponent: 	1st arg: non-empty input P, 					     %%%
%%%			2nd arg: output Omega, 						     %%%
%%%			3rd arg: output term of Omega	     				     %%%
%%% For the opponent: 	1st arg: non-empty input O, 					     %%%
%%%			2nd arg: output Omega, 						     %%%
%%%			3rd arg: output S from which Omega originates,			     %%%
%%%			4th arg: output term of Omega 					     %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

selectionFunction(L,Result)	:-
		user:sentence_choice(X),
		selectionFunction(X,L,Result).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Alternative selection function, choosing right-to-left, favoring newest sentence	     %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

selectionFunction(1,[H|_],H).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Alternative selection function, choosing left-to-right, favoring oldest sentence	     %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

selectionFunction(2,ListIn,End)	:- append(_,[End],ListIn). 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Patient selection function, always favoring non-assumptions				     %%% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

selectionFunction(3,[H|_],H)	:- \+ myAsm(H).
selectionFunction(3,[H|Tail],Rt):- myAsm(H), member(X,Tail), \+ myAsm(X), selectionFunction(3,Tail,Rt).
selectionFunction(3,[H|Tail],H)	:- myAsm(H), \+ (member(X,Tail), \+ myAsm(X) ).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Random selection function, pick one element at random				     %%% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

selectionFunction(4,List,Elem)	:- 
		length(List,Length),
		Upper is Length + 1,
		random(1,Upper,RandomNum),
		nth(RandomNum,List,Elem).

myAsm(X) :- user:myAsm(X).